# -*- coding: iso-8859-1 -*-
# vim: set ft=python ts=3 sw=3 expandtab:
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#
#              C E D A R
#          S O L U T I O N S       "Software done right."
#           S O F T W A R E
#
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#
# Author   : Kenneth J. Pronovici <pronovic@ieee.org>
# Language : Python (>= 2.2)
# Project  : WordUtils
# Revision : $Id: __init__.py,v 1.2 2003/07/16 05:47:06 pronovic Exp $
# Purpose  : Provides package initialization
#
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
# This file was created with a width of 132 characters, and NO tabs.

######################
# Pydoc Documentation
######################

"""
Word-related objects used for word searching and matching.

The WordUtils package provides objects related to word searching and matching.
The eventual goal is to develop a suite of objects that are suitable for
building word games in the tradition of Scrabble (tm).

All of the objects provide similar functionality with a similar interface, but
are implemented in terms of different underlying data structures.  Currently,
objects implementing two different data structures are complete: the Dawg
object, which implements a directed acyclic word graph, and the
TernarySearchTree object, which implements a ternary search tree.

@author: Kenneth J. Pronovici <pronovic@ieee.org>
"""


########################################################################
# Package initialization
########################################################################

# Using 'from WordUtils import *' will just import the modules listed
# in the __all__ variable.

__all__ = [ 'dawg', 'tree' ]

