# -*- coding: iso-8859-1 -*-
# vim: set ft=python ts=3 sw=3 expandtab:
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#
#              C E D A R
#          S O L U T I O N S       "Software done right."
#           S O F T W A R E
#
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#
# Author   : Kenneth J. Pronovici <pronovic@ieee.org>
# Language : Python (>= 2.3)
# Project  : WordUtils
# Revision : $Id: __init__.py,v 1.2 2003/07/16 05:47:06 pronovic Exp $
# Purpose  : Provides package initialization
#
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

########################################################################
# Module documentation
########################################################################

"""
Word-related objects used for word searching and matching.

The WordUtils sub-package provides objects related to word searching and
matching.  All of the objects provide similar functionality with a similar
interface, but are implemented in terms of different underlying data
structures.  Currently, objects implementing two different data structures are
complete: the Dawg object, which implements a directed acyclic word graph, and
the TernarySearchTree object, which implements a ternary search tree.

@author: Kenneth J. Pronovici <pronovic@ieee.org>
"""


########################################################################
# Package initialization
########################################################################

# Using 'from WordUtils import *' will just import the modules listed
# in the __all__ variable.

__all__ = [ 'dawg', 'tree' ]

