#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-
# vim: set ft=python ts=3 sw=3 expandtab:
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#
#              C E D A R
#          S O L U T I O N S       "Software done right."
#           S O F T W A R E
#
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#
# Author   : Kenneth J. Pronovici <pronovic@ieee.org>
# Language : Python (>= 2.3)
# Project  : WordUtils
# Revision : $Id: setup.py,v 1.3 2003/07/16 05:34:05 pronovic Exp $
# Purpose  : Python distutils setup script
#
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

########################################################################
# Imported modules
########################################################################

from distutils import core
from WordUtils.release import AUTHOR, EMAIL, VERSION, COPYRIGHT, URL


########################################################################
# Setup configuration
########################################################################

LONG_DESCRIPTION = """
The WordUtils package provides objects related to word searching and matching.
The eventual goal is to develop a suite of objects that are suitable for
building word games in the tradition of Scrabble (tm).

All of the objects provide similar functionality with a similar interface, but
are implemented in terms of different underlying data structures.  Currently,
objects implementing two different data structures are complete: the Dawg
object, which implements a directed acyclic word graph, and the
TernarySearchTree object, which implements a ternary search tree.
"""

kw =  { 
      'name'             : 'WordUtils',
      'version'          : VERSION,
      'description'      : 'Word-related objects used for word searching and matching.',
      'long_description' : LONG_DESCRIPTION,
      'keywords'         : None,
      'author'           : AUTHOR,
      'author_email'     : EMAIL,
      'url'              : URL, 
      'license'          : "Copyright (c) %s %s.   Licensed under the GNU GPL." % (COPYRIGHT, AUTHOR), 
      'platforms'        : ('Any',),
      'packages'         : ['WordUtils',],
      }

if hasattr(core, 'setup_keywords') and 'classifiers' in core.setup_keywords:
   kw['classifiers'] =  [
                        'Development Status :: 5 - Production/Stable',
                        'Intended Audience :: Developers',
                        'License :: OSI Approved :: GNU General Public License (GPL)',
                        'Natural Language :: English',
                        'Programming Language :: Python',
                        'Topic :: Software Development :: Libraries :: Python Modules',
                        'Topic :: Games/Entertainment :: Board Games',
                        ]

if hasattr(core, 'setup_keywords') and 'download_url' in core.setup_keywords:
      kw['download_url'] = 'http://cedar-solutions.com/ftp/software/WordUtils-%s.tar.gz' % VERSION

core.setup(**kw)

