#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-
# vim: set ft=python ts=3 sw=3 expandtab:
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#
# Copyright (c) 2005-2006 Kenneth J. Pronovici.
# All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License,
# Version 2, as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
# Copies of the GNU General Public License are available from
# the Free Software Foundation website, http://www.gnu.org/.
#
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#
# Author   : Kenneth J. Pronovici <pronovic@ieee.org>
# Language : Python (>= 2.3)
# Project  : WordUtils
# Revision : $Id: test.py 950 2006-04-05 02:48:22Z pronovic $
# Purpose  : Run all of the unit tests for the project.
#
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

########################################################################
# Notes
########################################################################

"""
Run all of the WordUtils unit tests.

We run all of the unit tests here at once so we can get one big success or
failure result, rather than a bunch of different smaller results that we
somehow have to aggregate together to get the "big picture".  This is done by
creating and running one big unit test suite based on the suites in the
individual unit test modules.

The composite suite is always run using the TextTestRunner at verbosity level
1, which prints one dot (".") on the screen for each test run.  This output is
the same as one would get when using unittest.main() in an individual test.

Generally, I'm trying to keep all of the "special" validation logic (i.e. did
we find the right Python, did we find the right libraries, etc.) in this code
rather than in the individual unit tests so they're more focused on what to
test than how their environment should be configured.

We want to make sure the tests use the modules in the current source tree, not
any versions previously-installed elsewhere, if possible.  We don't actually
import the modules here, but we warn if the wrong ones would be found.  We also
want to make sure we are running the correct 'test' package - not one found
elsewhere on the user's path - since 'test' could be a relatively common name
for a package.

@author: Kenneth J. Pronovici <pronovic@ieee.org>
"""

########################################################################
# Imported modules
########################################################################

import sys
import os
import logging
import unittest


##################
# main() function
##################

def main():

   """
   Main routine for program.
   """

   # Check the Python version.  We require 2.3 or greater.
   try:
      if map(int, [sys.version_info[0], sys.version_info[1]]) < [2, 3]:
         print "Python version 2.3 or greater required, sorry."
         sys.exit(1)
   except:
      # sys.version_info isn't available before 2.0
      print "Python version 2.3 or greater required, sorry."
      sys.exit(1)

   # Check for the correct WordUtils location
   if os.path.exists(os.path.join(".", "WordUtils", "tree.py")):
      sys.path.insert(0, ".")
   elif os.path.basename(os.getcwd()) == "test" and os.path.exists(os.path.join("..", "WordUtils", "tree.py")):
      sys.path.insert(0, "..")
   else:
      print "WARNING: WordUtils modules were not found in the expected"
      print "location.  If the import succeeds, you may be using an"
      print "unexpected version of WordUtils."
      print ""

   # Import the unit test modules
   try:
      if os.path.exists(os.path.join(".", "test", "treetests.py")):
         sys.path.insert(0, ".")
      elif os.path.basename(os.getcwd()) == "test" and os.path.exists(os.path.join("..", "test", "treetests.py")):
         sys.path.insert(0, "..")
      else:
         print "WARNING: WordUtils unit test modules were not found in"
         print "the expected location.  If the import succeeds, you may be"
         print "using an unexpected version of the test suite."
         print ""
      import test.treetests as treetests
      import test.dawgtests as dawgtests
   except ImportError, e:
      print "Failed to import WordUtils unit test module: %s" % e
      print "You must either run the unit tests from the WordUtils source"
      print "tree, or properly set the PYTHONPATH enviroment variable."
      sys.exit(1)

   # Set up logging to discard everything
   handler = logging.FileHandler(filename="/dev/null")
   handler.setLevel(logging.NOTSET)
   logger = logging.getLogger("WordUtils")
   logger.setLevel(logging.NOTSET)
   logger.addHandler(handler)

   # Print a starting banner
   print "\n*** Running WordUtils unit tests."

   # Create and run the test suite
   print ""
   suite = unittest.TestSuite((
                               treetests.suite(),
                               dawgtests.suite(),
                              ))
   unittest.TextTestRunner(verbosity=1).run(suite)
   print ""


########################################################################
# Module entry point
########################################################################

# Run the main routine if the module is executed rather than sourced
if __name__ == '__main__':
   main()

