#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-
# vim: set ft=python ts=3 sw=3 expandtab:
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#
# Author   : Kenneth J. Pronovici <pronovic@ieee.org>
# Language : Python (>= 2.3)
# Project  : WordUtils
# Revision : $Id: setup.py,v 1.3 2003/07/16 05:34:05 pronovic Exp $
# Purpose  : Python distutils setup script
#
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

########################################################################
# Imported modules
########################################################################

from distutils.core import setup
from WordUtils.release import VERSION


########################################################################
# Setup configuration
########################################################################

LONG_DESCRIPTION = """
The WordUtils package provides objects related to word searching and matching.
The eventual goal is to develop a suite of objects that are suitable for
building word games in the tradition of Scrabble (tm).

All of the objects provide similar functionality with a similar interface, but
are implemented in terms of different underlying data structures.  Currently,
objects implementing two different data structures are complete: the Dawg
object, which implements a directed acyclic word graph, and the
TernarySearchTree object, which implements a ternary search tree.

This package was originally developed by Kenneth J. Pronovici and was hosted at
cedar-solutions.com.  Ken has since given up primary maintainership of the
package, and it is now hosted at SourceForge where most ongoing development
will be done by Bob Gibson.  The 0.8.2 release is the last release compatible
with the original public interface.
"""

setup (
   name             = 'WordUtils',
   version          = VERSION,
   description      = 'Word-related objects used for word searching and matching.',
   long_description = LONG_DESCRIPTION,
   keywords         = None,
   author           = "Kenneth J. Pronovici",
   author_email     = None,
   url              = None,
   license          = "Copyright (c) 2003-2007 Kenneth J. Pronovici, under the GNU GPL.",
   platforms        = ('Any',),
   packages         = ['WordUtils',],
   scripts          = None
)

