/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *              C E D A R
 *          S O L U T I O N S       "Software done right."
 *           S O F T W A R E
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * Copyright (c) 2000-2003 Kenneth J. Pronovici.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * Version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Copies of the GNU General Public License are available from
 * the Free Software Foundation website, http://www.gnu.org/.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 * Author   : Kenneth J. Pronovici <pronovic@ieee.org>
 * Language : ANSI C
 * Project  : banner
 * Revision : $Id: banner.h,v 1.6 2003/09/08 22:45:06 pronovic Exp $
 * Purpose  : Main header file
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef BANNER_H
#define BANNER_H
/*{*/

/***********************
  Included system files
 ***********************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/*********************
  Program-wide macros
 *********************/

#define BANNER_DEF_SIZE       (10)   /* Just need to initialize to SOMEthing...*/

#define BANNER_SPACE_STR      (" ")

#define BANNER_NORMAL_EXIT    (0)
#define BANNER_ERROR_EXIT     (-1)

#define BANNER_ARG_HELP_STR   ("--help")
#define BANNER_ARG_IGNORE_STR ("--")

#define BANNER_GNU_URL        ("http://www.gnu.org/")
#define BANNER_COPYRIGHT_DATE ("2000-2003")
#define BANNER_AUTHOR         ("Kenneth J. Pronovici")
#define BANNER_AUTHOR_EMAIL   ("pronovic@ieee.org")


/**********************
  Included local files
 **********************/

#include "letters.h"                 /* Def'n of 'font' and associated macros */
#include "config.h"                  /* Generated by the configure script. */


/**********************************
  Program-wide function prototypes
 **********************************/

void convert_to_upper(char *string);
void add_to_banner(char **banner, long height, long space, char letter);
void init_banner(char **banner, long height);
void print_banner(char **banner, long height);
void usage(char *program);


/*}*/
#endif /* ifndef BANNER_H */
